/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.value;

import java.nio.charset.Charset;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import java.util.Objects;
import org.gridgain.internal.h2.engine.SysProperties;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.util.StringUtils;
import org.gridgain.internal.h2.value.CharsetCollator;
import org.gridgain.internal.h2.value.CompareModeDefault;
import org.gridgain.internal.h2.value.Value;

public class CompareMode
implements Comparator<Value> {
    public static final String OFF = "OFF";
    public static final String DEFAULT = "DEFAULT_";
    public static final String ICU4J = "ICU4J_";
    public static final String CHARSET = "CHARSET_";
    public static final String SIGNED = "SIGNED";
    public static final String UNSIGNED = "UNSIGNED";
    private static volatile CompareMode lastUsed;
    private final String name;
    private final int strength;
    private final boolean binaryUnsigned;
    private final boolean uuidUnsigned;

    protected CompareMode(String name, int strength, boolean binaryUnsigned, boolean uuidUnsigned) {
        this.name = name;
        this.strength = strength;
        this.binaryUnsigned = binaryUnsigned;
        this.uuidUnsigned = uuidUnsigned;
    }

    public static CompareMode getInstance(String name, int strength) {
        return CompareMode.getInstance(name, strength, SysProperties.SORT_BINARY_UNSIGNED, SysProperties.SORT_UUID_UNSIGNED);
    }

    public static CompareMode getInstance(String name, int strength, boolean binaryUnsigned, boolean uuidUnsigned) {
        CompareMode last = lastUsed;
        if (last != null && Objects.equals(last.name, name) && last.strength == strength && last.binaryUnsigned == binaryUnsigned && last.uuidUnsigned == uuidUnsigned) {
            return last;
        }
        if (name == null || name.equals(OFF)) {
            last = new CompareMode(name, strength, binaryUnsigned, uuidUnsigned);
        } else {
            if (name.startsWith(ICU4J)) {
                throw DbException.getInvalidValueException("collation", name);
            }
            if (name.startsWith(DEFAULT)) {
                name = name.substring(DEFAULT.length());
            }
            last = new CompareModeDefault(name, strength, binaryUnsigned, uuidUnsigned);
        }
        lastUsed = last;
        return last;
    }

    public boolean equalsChars(String a, int ai, String b, int bi, boolean ignoreCase) {
        char ca = a.charAt(ai);
        char cb = b.charAt(bi);
        if (ignoreCase) {
            ca = Character.toUpperCase(ca);
            cb = Character.toUpperCase(cb);
        }
        return ca == cb;
    }

    public int compareString(String a, String b, boolean ignoreCase) {
        if (ignoreCase) {
            return a.compareToIgnoreCase(b);
        }
        return a.compareTo(b);
    }

    public static String getName(Locale l) {
        Locale english = Locale.ENGLISH;
        String name = l.getDisplayLanguage(english) + ' ' + l.getDisplayCountry(english) + ' ' + l.getVariant();
        name = StringUtils.toUpperEnglish(name.trim().replace(' ', '_'));
        return name;
    }

    static boolean compareLocaleNames(Locale locale, String name) {
        return name.equalsIgnoreCase(locale.toString()) || name.equalsIgnoreCase(CompareMode.getName(locale));
    }

    public static Collator getCollator(String name) {
        String country;
        String language;
        Locale locale3;
        int idx;
        Collator result = null;
        if (name.startsWith(ICU4J)) {
            name = name.substring(ICU4J.length());
        } else if (name.startsWith(DEFAULT)) {
            name = name.substring(DEFAULT.length());
        } else if (name.startsWith(CHARSET)) {
            return new CharsetCollator(Charset.forName(name.substring(CHARSET.length())));
        }
        int length = name.length();
        if (length == 2) {
            Locale locale2 = new Locale(StringUtils.toLowerEnglish(name), "");
            if (CompareMode.compareLocaleNames(locale2, name)) {
                result = Collator.getInstance(locale2);
            }
        } else if (length == 5 && (idx = name.indexOf(95)) >= 0 && CompareMode.compareLocaleNames(locale3 = new Locale(language = StringUtils.toLowerEnglish(name.substring(0, idx)), country = name.substring(idx + 1)), name)) {
            result = Collator.getInstance(locale3);
        }
        if (result == null) {
            for (Locale locale3 : Collator.getAvailableLocales()) {
                if (!CompareMode.compareLocaleNames(locale3, name)) continue;
                result = Collator.getInstance(locale3);
                break;
            }
        }
        return result;
    }

    public String getName() {
        return this.name == null ? OFF : this.name;
    }

    public int getStrength() {
        return this.strength;
    }

    public boolean isBinaryUnsigned() {
        return this.binaryUnsigned;
    }

    public boolean isUuidUnsigned() {
        return this.uuidUnsigned;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CompareMode)) {
            return false;
        }
        CompareMode o = (CompareMode)obj;
        if (!this.getName().equals(o.getName())) {
            return false;
        }
        if (this.strength != o.strength) {
            return false;
        }
        if (this.binaryUnsigned != o.binaryUnsigned) {
            return false;
        }
        return this.uuidUnsigned == o.uuidUnsigned;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.getName().hashCode();
        result = 31 * result + this.strength;
        result = 31 * result + (this.binaryUnsigned ? 1231 : 1237);
        result = 31 * result + (this.uuidUnsigned ? 1231 : 1237);
        return result;
    }

    @Override
    public int compare(Value o1, Value o2) {
        return o1.compareTo(o2, null, this);
    }
}

