/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.util;

import java.util.Arrays;

public class IntArray {
    private int[] data;
    private int size;
    private int hash;

    public IntArray() {
        this(10);
    }

    public IntArray(int capacity) {
        this.data = new int[capacity];
    }

    public IntArray(int[] data) {
        this.data = data;
        this.size = data.length;
    }

    public void add(int value) {
        if (this.size >= this.data.length) {
            this.ensureCapacity(this.size + this.size);
        }
        this.data[this.size++] = value;
    }

    public int get(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException("i=" + index + " size=" + this.size);
        }
        return this.data[index];
    }

    public void remove(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException("i=" + index + " size=" + this.size);
        }
        System.arraycopy(this.data, index + 1, this.data, index, this.size - index - 1);
        --this.size;
    }

    public void ensureCapacity(int minCapacity) {
        if ((minCapacity = Math.max(4, minCapacity)) >= this.data.length) {
            this.data = Arrays.copyOf(this.data, minCapacity);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IntArray)) {
            return false;
        }
        IntArray other = (IntArray)obj;
        if (this.hashCode() != other.hashCode() || this.size != other.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] == other.data[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        int h = this.size + 1;
        for (int i = 0; i < this.size; ++i) {
            h = h * 31 + this.data[i];
        }
        this.hash = h;
        return h;
    }

    public int size() {
        return this.size;
    }

    public void toArray(int[] array) {
        System.arraycopy(this.data, 0, array, 0, this.size);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(this.data[i]);
        }
        return builder.append('}').toString();
    }

    public void removeRange(int fromIndex, int toIndex) {
        if (fromIndex > toIndex || toIndex > this.size) {
            throw new ArrayIndexOutOfBoundsException("from=" + fromIndex + " to=" + toIndex + " size=" + this.size);
        }
        System.arraycopy(this.data, toIndex, this.data, fromIndex, this.size - toIndex);
        this.size -= toIndex - fromIndex;
    }
}

