/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.store;

import java.io.IOException;
import java.io.InputStream;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.store.DataHandler;
import org.gridgain.internal.h2.value.ValueLobDb;

class LobStorageRemoteInputStream
extends InputStream {
    private final DataHandler handler;
    private final long lob;
    private final byte[] hmac;
    private long pos;
    private long remainingBytes;

    public LobStorageRemoteInputStream(DataHandler handler, ValueLobDb lob, byte[] hmac, long byteCount) {
        this.handler = handler;
        this.lob = lob.getLobId();
        this.hmac = hmac;
        this.remainingBytes = byteCount;
    }

    @Override
    public int read() throws IOException {
        byte[] buff = new byte[1];
        int len = this.read(buff, 0, 1);
        return len < 0 ? len : buff[0] & 0xFF;
    }

    @Override
    public int read(byte[] buff) throws IOException {
        return this.read(buff, 0, buff.length);
    }

    @Override
    public int read(byte[] buff, int off, int length) throws IOException {
        if (length == 0) {
            return 0;
        }
        if ((length = (int)Math.min((long)length, this.remainingBytes)) == 0) {
            return -1;
        }
        try {
            length = this.handler.readLob(this.lob, this.hmac, this.pos, buff, off, length);
        }
        catch (DbException e) {
            throw DbException.convertToIOException(e);
        }
        if (length == 0) {
            return -1;
        }
        this.remainingBytes -= (long)length;
        this.pos += (long)length;
        return length;
    }

    @Override
    public long skip(long n) {
        this.remainingBytes -= n;
        this.pos += n;
        return n;
    }
}

