/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.expression.condition;

import org.gridgain.internal.h2.command.dml.Query;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.ExpressionVisitor;
import org.gridgain.internal.h2.expression.condition.Condition;
import org.gridgain.internal.h2.result.ResultInterface;
import org.gridgain.internal.h2.table.ColumnResolver;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.util.StringUtils;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueBoolean;

public class ConditionExists
extends Condition {
    private final Query query;

    public ConditionExists(Query query) {
        this.query = query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value getValue(Session session) {
        this.query.setSession(session);
        ResultInterface lastResult = this.query.getLastResult();
        ResultInterface result = this.query.query(1);
        try {
            session.addTemporaryResult(result);
            boolean r = result.hasNext();
            ValueBoolean valueBoolean = ValueBoolean.get(r);
            return valueBoolean;
        }
        finally {
            if (lastResult != null || this.query.ignoreCaching()) {
                result.close();
            }
        }
    }

    @Override
    public Expression optimize(Session session) {
        session.optimizeQueryExpression(this.query);
        return this;
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, boolean alwaysQuote) {
        builder.append("EXISTS(\n");
        return StringUtils.indent(builder, this.query.getPlanSQL(alwaysQuote), 4, false).append(')');
    }

    @Override
    public void updateAggregate(Session session, int stage) {
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level, int state) {
        this.query.mapColumns(resolver, level + 1);
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        this.query.setEvaluatable(tableFilter, b);
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        return this.query.isEverything(visitor);
    }

    @Override
    public int getCost() {
        return this.query.getCostAsExpression();
    }
}

