/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.expression.analysis;

import java.util.ArrayList;
import org.gridgain.internal.h2.command.dml.Select;
import org.gridgain.internal.h2.command.dml.SelectOrderBy;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.analysis.WindowFrame;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.result.SortOrder;
import org.gridgain.internal.h2.table.ColumnResolver;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueRow;

public final class Window {
    private ArrayList<Expression> partitionBy;
    private ArrayList<SelectOrderBy> orderBy;
    private WindowFrame frame;
    private String parent;

    public static void appendOrderBy(StringBuilder builder, ArrayList<SelectOrderBy> orderBy, boolean alwaysQuote) {
        if (orderBy != null && !orderBy.isEmpty()) {
            if (builder.charAt(builder.length() - 1) != '(') {
                builder.append(' ');
            }
            builder.append("ORDER BY ");
            for (int i = 0; i < orderBy.size(); ++i) {
                SelectOrderBy o = orderBy.get(i);
                if (i > 0) {
                    builder.append(", ");
                }
                o.expression.getSQL(builder, alwaysQuote);
                SortOrder.typeToString(builder, o.sortType);
            }
        }
    }

    public Window(String parent, ArrayList<Expression> partitionBy, ArrayList<SelectOrderBy> orderBy, WindowFrame frame) {
        this.parent = parent;
        this.partitionBy = partitionBy;
        this.orderBy = orderBy;
        this.frame = frame;
    }

    public void mapColumns(ColumnResolver resolver, int level) {
        this.resolveWindows(resolver);
        if (this.partitionBy != null) {
            for (Expression e : this.partitionBy) {
                e.mapColumns(resolver, level, 1);
            }
        }
        if (this.orderBy != null) {
            for (SelectOrderBy o : this.orderBy) {
                o.expression.mapColumns(resolver, level, 1);
            }
        }
        if (this.frame != null) {
            this.frame.mapColumns(resolver, level, 1);
        }
    }

    private void resolveWindows(ColumnResolver resolver) {
        if (this.parent != null) {
            Window p;
            Select select = resolver.getSelect();
            while ((p = select.getWindow(this.parent)) == null) {
                if ((select = select.getParentSelect()) != null) continue;
                throw DbException.get(90136, this.parent);
            }
            p.resolveWindows(resolver);
            if (this.partitionBy == null) {
                this.partitionBy = p.partitionBy;
            }
            if (this.orderBy == null) {
                this.orderBy = p.orderBy;
            }
            if (this.frame == null) {
                this.frame = p.frame;
            }
            this.parent = null;
        }
    }

    public void optimize(Session session) {
        if (this.partitionBy != null) {
            for (int i = 0; i < this.partitionBy.size(); ++i) {
                this.partitionBy.set(i, this.partitionBy.get(i).optimize(session));
            }
        }
        if (this.orderBy != null) {
            for (SelectOrderBy o : this.orderBy) {
                o.expression = o.expression.optimize(session);
            }
        }
        if (this.frame != null) {
            this.frame.optimize(session);
        }
    }

    public void setEvaluatable(TableFilter tableFilter, boolean value) {
        if (this.partitionBy != null) {
            for (Expression e : this.partitionBy) {
                e.setEvaluatable(tableFilter, value);
            }
        }
        if (this.orderBy != null) {
            for (SelectOrderBy o : this.orderBy) {
                o.expression.setEvaluatable(tableFilter, value);
            }
        }
    }

    public ArrayList<SelectOrderBy> getOrderBy() {
        return this.orderBy;
    }

    public WindowFrame getWindowFrame() {
        return this.frame;
    }

    public Value getCurrentKey(Session session) {
        if (this.partitionBy == null) {
            return null;
        }
        int len = this.partitionBy.size();
        if (len == 1) {
            return this.partitionBy.get(0).getValue(session);
        }
        Value[] keyValues = new Value[len];
        for (int i = 0; i < len; ++i) {
            Expression expr = this.partitionBy.get(i);
            keyValues[i] = expr.getValue(session);
        }
        return ValueRow.get(keyValues);
    }

    public StringBuilder getSQL(StringBuilder builder, boolean alwaysQuote) {
        builder.append("OVER (");
        if (this.partitionBy != null) {
            builder.append("PARTITION BY ");
            for (int i = 0; i < this.partitionBy.size(); ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                this.partitionBy.get(i).getUnenclosedSQL(builder, alwaysQuote);
            }
        }
        Window.appendOrderBy(builder, this.orderBy, alwaysQuote);
        if (this.frame != null) {
            if (builder.charAt(builder.length() - 1) != '(') {
                builder.append(' ');
            }
            this.frame.getSQL(builder, alwaysQuote);
        }
        return builder.append(')');
    }

    public void updateAggregate(Session session, int stage) {
        if (this.partitionBy != null) {
            for (Expression expr : this.partitionBy) {
                expr.updateAggregate(session, stage);
            }
        }
        if (this.orderBy != null) {
            for (SelectOrderBy o : this.orderBy) {
                o.expression.updateAggregate(session, stage);
            }
        }
        if (this.frame != null) {
            this.frame.updateAggregate(session, stage);
        }
    }

    public String toString() {
        return this.getSQL(new StringBuilder(), false).toString();
    }
}

