/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.expression;

import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.ExpressionVisitor;
import org.gridgain.internal.h2.expression.ValueExpression;
import org.gridgain.internal.h2.table.ColumnResolver;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueNull;

public class UnaryOperation
extends Expression {
    private Expression arg;
    private TypeInfo type;

    public UnaryOperation(Expression arg) {
        this.arg = arg;
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, boolean alwaysQuote) {
        builder.append("(- ");
        return this.arg.getSQL(builder, alwaysQuote).append(')');
    }

    @Override
    public Value getValue(Session session) {
        Value a = this.arg.getValue(session).convertTo(this.type, session.getDatabase().getMode(), null);
        return a == ValueNull.INSTANCE ? a : a.negate();
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level, int state) {
        this.arg.mapColumns(resolver, level, state);
    }

    @Override
    public Expression optimize(Session session) {
        this.arg = this.arg.optimize(session);
        this.type = this.arg.getType();
        if (this.type.getValueType() == -1) {
            this.type = TypeInfo.TYPE_DECIMAL_DEFAULT;
        } else if (this.type.getValueType() == 25) {
            this.type = TypeInfo.TYPE_INT;
        }
        if (this.arg.isConstant()) {
            return ValueExpression.get(this.getValue(session));
        }
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        this.arg.setEvaluatable(tableFilter, b);
    }

    @Override
    public TypeInfo getType() {
        return this.type;
    }

    @Override
    public void updateAggregate(Session session, int stage) {
        this.arg.updateAggregate(session, stage);
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        return this.arg.isEverything(visitor);
    }

    @Override
    public int getCost() {
        return this.arg.getCost() + 1;
    }

    @Override
    public int getSubexpressionCount() {
        return 1;
    }

    @Override
    public Expression getSubexpression(int index) {
        if (index == 0) {
            return this.arg;
        }
        throw new IndexOutOfBoundsException();
    }
}

