/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.command.dml;

import java.util.BitSet;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.gridgain.internal.h2.command.dml.AllColumnsForPlan;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.table.Plan;
import org.gridgain.internal.h2.table.PlanItem;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.util.Permutations;

class Optimizer {
    private static final int MAX_BRUTE_FORCE_FILTERS = 7;
    private static final int MAX_BRUTE_FORCE = 2000;
    private static final int MAX_GENETIC = 500;
    private long startNs;
    private BitSet switched;
    private final TableFilter[] filters;
    private final Expression condition;
    private final Session session;
    private Plan bestPlan;
    private TableFilter topFilter;
    private double cost;
    private Random random;
    private final AllColumnsForPlan allColumnsSet;

    Optimizer(TableFilter[] filters, Expression condition, Session session) {
        this.filters = filters;
        this.condition = condition;
        this.session = session;
        this.allColumnsSet = new AllColumnsForPlan(filters);
    }

    private static int getMaxBruteForceFilters(int filterCount) {
        int i = 0;
        int j = filterCount;
        int total = filterCount;
        while (j > 0 && total * (j * (j - 1) / 2) < 2000) {
            total *= --j;
            ++i;
        }
        return i;
    }

    private void calculateBestPlan() {
        this.cost = -1.0;
        if (this.filters.length == 1 || this.session.isForceJoinOrder()) {
            this.testPlan(this.filters);
        } else {
            this.startNs = System.nanoTime();
            if (this.filters.length <= 7) {
                this.calculateBruteForceAll();
            } else {
                this.calculateBruteForceSome();
                this.random = new Random(0L);
                this.calculateGenetic();
            }
        }
    }

    private void calculateFakePlan() {
        this.cost = -1.0;
        this.bestPlan = new Plan(this.filters, this.filters.length, this.condition);
    }

    private boolean canStop(int x) {
        return (x & 0x7F) == 0 && this.cost >= 0.0 && (double)(10L * (System.nanoTime() - this.startNs)) > this.cost * (double)TimeUnit.MILLISECONDS.toNanos(1L);
    }

    private void calculateBruteForceAll() {
        TableFilter[] list = new TableFilter[this.filters.length];
        Permutations<TableFilter> p = Permutations.create(this.filters, list);
        int x = 0;
        while (!this.canStop(x) && p.next()) {
            this.testPlan(list);
            ++x;
        }
    }

    private void calculateBruteForceSome() {
        int bruteForce = Optimizer.getMaxBruteForceFilters(this.filters.length);
        TableFilter[] list = new TableFilter[this.filters.length];
        Permutations<TableFilter> p = Permutations.create(this.filters, list, bruteForce);
        int x = 0;
        while (!this.canStop(x) && p.next()) {
            int i;
            for (TableFilter f : this.filters) {
                f.setUsed(false);
            }
            for (i = 0; i < bruteForce; ++i) {
                list[i].setUsed(true);
            }
            for (i = bruteForce; i < this.filters.length; ++i) {
                double costPart = -1.0;
                int bestPart = -1;
                for (int j = 0; j < this.filters.length; ++j) {
                    if (this.filters[j].isUsed()) continue;
                    if (i == this.filters.length - 1) {
                        bestPart = j;
                        break;
                    }
                    list[i] = this.filters[j];
                    Plan part = new Plan(list, i + 1, this.condition);
                    double costNow = part.calculateCost(this.session, this.allColumnsSet);
                    if (!(costPart < 0.0) && !(costNow < costPart)) continue;
                    costPart = costNow;
                    bestPart = j;
                }
                this.filters[bestPart].setUsed(true);
                list[i] = this.filters[bestPart];
            }
            this.testPlan(list);
            ++x;
        }
    }

    private void calculateGenetic() {
        TableFilter[] best = new TableFilter[this.filters.length];
        TableFilter[] list = new TableFilter[this.filters.length];
        for (int x = 0; x < 500 && !this.canStop(x); ++x) {
            boolean generateRandom;
            boolean bl = generateRandom = (x & 0x7F) == 0;
            if (!generateRandom) {
                System.arraycopy(best, 0, list, 0, this.filters.length);
                if (!this.shuffleTwo(list)) {
                    generateRandom = true;
                }
            }
            if (generateRandom) {
                this.switched = new BitSet();
                System.arraycopy(this.filters, 0, best, 0, this.filters.length);
                this.shuffleAll(best);
                System.arraycopy(best, 0, list, 0, this.filters.length);
            }
            if (!this.testPlan(list)) continue;
            this.switched = new BitSet();
            System.arraycopy(list, 0, best, 0, this.filters.length);
        }
    }

    private boolean testPlan(TableFilter[] list) {
        Plan p = new Plan(list, list.length, this.condition);
        double costNow = p.calculateCost(this.session, this.allColumnsSet);
        if (this.cost < 0.0 || costNow < this.cost) {
            this.cost = costNow;
            this.bestPlan = p;
            return true;
        }
        return false;
    }

    private void shuffleAll(TableFilter[] f) {
        for (int i = 0; i < f.length - 1; ++i) {
            int j = i + this.random.nextInt(f.length - i);
            if (j == i) continue;
            TableFilter temp = f[i];
            f[i] = f[j];
            f[j] = temp;
        }
    }

    private boolean shuffleTwo(TableFilter[] f) {
        int i;
        int a = 0;
        int b = 0;
        for (i = 0; i < 20; ++i) {
            int s;
            a = this.random.nextInt(f.length);
            if (a == (b = this.random.nextInt(f.length))) continue;
            if (a < b) {
                int temp = a;
                a = b;
                b = temp;
            }
            if (this.switched.get(s = a * f.length + b)) continue;
            this.switched.set(s);
            break;
        }
        if (i == 20) {
            return false;
        }
        TableFilter temp = f[a];
        f[a] = f[b];
        f[b] = temp;
        return true;
    }

    void optimize(boolean parse) {
        if (parse) {
            this.calculateFakePlan();
        } else {
            this.calculateBestPlan();
            this.bestPlan.removeUnusableIndexConditions();
        }
        TableFilter[] f2 = this.bestPlan.getFilters();
        this.topFilter = f2[0];
        for (int i = 0; i < f2.length - 1; ++i) {
            f2[i].addJoin(f2[i + 1], false, null);
        }
        if (parse) {
            return;
        }
        for (TableFilter f : f2) {
            PlanItem item = this.bestPlan.getItem(f);
            f.setPlanItem(item);
        }
    }

    public TableFilter getTopFilter() {
        return this.topFilter;
    }

    double getCost() {
        return this.cost;
    }
}

