/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.command.ddl;

import java.util.ArrayList;
import org.gridgain.internal.h2.command.ddl.DefineCommand;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.DbObject;
import org.gridgain.internal.h2.engine.Right;
import org.gridgain.internal.h2.engine.RightOwner;
import org.gridgain.internal.h2.engine.Role;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.schema.Schema;
import org.gridgain.internal.h2.table.Table;
import org.gridgain.internal.h2.util.Utils;

public class GrantRevoke
extends DefineCommand {
    private ArrayList<String> roleNames;
    private int operationType;
    private int rightMask;
    private final ArrayList<Table> tables = Utils.newSmallArrayList();
    private Schema schema;
    private RightOwner grantee;

    public GrantRevoke(Session session) {
        super(session);
    }

    public void setOperationType(int operationType) {
        this.operationType = operationType;
    }

    public void addRight(int right) {
        this.rightMask |= right;
    }

    public void addRoleName(String roleName) {
        if (this.roleNames == null) {
            this.roleNames = Utils.newSmallArrayList();
        }
        this.roleNames.add(roleName);
    }

    public void setGranteeName(String granteeName) {
        Database db = this.session.getDatabase();
        this.grantee = db.findUser(granteeName);
        if (this.grantee == null) {
            this.grantee = db.findRole(granteeName);
            if (this.grantee == null) {
                throw DbException.get(90071, granteeName);
            }
        }
    }

    @Override
    public int update() {
        this.session.getUser().checkAdmin();
        this.session.commit(true);
        Database db = this.session.getDatabase();
        if (this.roleNames != null) {
            for (String name : this.roleNames) {
                Role grantedRole = db.findRole(name);
                if (grantedRole == null) {
                    throw DbException.get(90070, name);
                }
                if (this.operationType == 49) {
                    this.grantRole(grantedRole);
                    continue;
                }
                if (this.operationType == 50) {
                    this.revokeRole(grantedRole);
                    continue;
                }
                DbException.throwInternalError("type=" + this.operationType);
            }
        } else if (this.operationType == 49) {
            this.grantRight();
        } else if (this.operationType == 50) {
            this.revokeRight();
        } else {
            DbException.throwInternalError("type=" + this.operationType);
        }
        return 0;
    }

    private void grantRight() {
        if (this.schema != null) {
            this.grantRight(this.schema);
        }
        for (Table table : this.tables) {
            this.grantRight(table);
        }
    }

    private void grantRight(DbObject object) {
        Database db = this.session.getDatabase();
        Right right = this.grantee.getRightForObject(object);
        if (right == null) {
            int id = this.getObjectId();
            right = new Right(db, id, this.grantee, this.rightMask, object);
            this.grantee.grantRight(object, right);
            db.addDatabaseObject(this.session, right);
        } else {
            right.setRightMask(right.getRightMask() | this.rightMask);
            db.updateMeta(this.session, right);
        }
    }

    private void grantRole(Role grantedRole) {
        Role granteeRole;
        if (grantedRole != this.grantee && this.grantee.isRoleGranted(grantedRole)) {
            return;
        }
        if (this.grantee instanceof Role && grantedRole.isRoleGranted(granteeRole = (Role)this.grantee)) {
            throw DbException.get(90074, grantedRole.getSQL(false));
        }
        Database db = this.session.getDatabase();
        int id = this.getObjectId();
        Right right = new Right(db, id, this.grantee, grantedRole);
        db.addDatabaseObject(this.session, right);
        this.grantee.grantRole(grantedRole, right);
    }

    private void revokeRight() {
        if (this.schema != null) {
            this.revokeRight(this.schema);
        }
        for (Table table : this.tables) {
            this.revokeRight(table);
        }
    }

    private void revokeRight(DbObject object) {
        Right right = this.grantee.getRightForObject(object);
        if (right == null) {
            return;
        }
        int mask = right.getRightMask();
        int newRight = mask & ~this.rightMask;
        Database db = this.session.getDatabase();
        if (newRight == 0) {
            db.removeDatabaseObject(this.session, right);
        } else {
            right.setRightMask(newRight);
            db.updateMeta(this.session, right);
        }
    }

    private void revokeRole(Role grantedRole) {
        Right right = this.grantee.getRightForRole(grantedRole);
        if (right == null) {
            return;
        }
        Database db = this.session.getDatabase();
        db.removeDatabaseObject(this.session, right);
    }

    @Override
    public boolean isTransactional() {
        return false;
    }

    public void addTable(Table table) {
        this.tables.add(table);
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    @Override
    public int getType() {
        return this.operationType;
    }

    public boolean isRoleMode() {
        return this.roleNames != null;
    }

    public boolean isRightMode() {
        return this.rightMask != 0;
    }
}

