/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.gmc.connector.config;

import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.NotEmpty;
import lombok.Generated;
import org.gridgain.gmc.annotation.URL;
import org.gridgain.gmc.connector.config.ConnectorProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.validation.annotation.Validated;

@Validated
@Configuration
@ConfigurationProperties(prefix="connector")
public class StandaloneConnectorProperties
implements ConnectorProperties {
    @URL
    @NotEmpty(message="Nebula or Control Center url must be configured.")
    private @URL @NotEmpty(message="Nebula or Control Center url must be configured.") String ccUrl;
    @URL
    @NotEmpty(message="Connector base url must be configured. Specify Connector url reachable from all cluster nodes.")
    private @URL @NotEmpty(message="Connector base url must be configured. Specify Connector url reachable from all cluster nodes.") String baseUrl;
    @NotEmpty(message="Connector name must be configured.")
    private @NotEmpty(message="Connector name must be configured.") String name;
    private String username;
    private String password;
    private String token;

    @AssertTrue(message="Username and password properties should be configured.")
    public @AssertTrue(message="Username and password properties should be configured.") boolean isValidCredentials() {
        boolean tokenProvided = this.token != null && !this.token.isBlank();
        boolean usernamePasswordProvided = this.username != null && !this.username.isBlank() && this.password != null && !this.password.isBlank();
        return tokenProvided && !usernamePasswordProvided || !tokenProvided && usernamePasswordProvided;
    }

    @Generated
    public StandaloneConnectorProperties() {
    }

    @Generated
    public String getCcUrl() {
        return this.ccUrl;
    }

    @Generated
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getToken() {
        return this.token;
    }

    @Generated
    public StandaloneConnectorProperties setCcUrl(String ccUrl) {
        this.ccUrl = ccUrl;
        return this;
    }

    @Generated
    public StandaloneConnectorProperties setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    @Generated
    public StandaloneConnectorProperties setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public StandaloneConnectorProperties setUsername(String username) {
        this.username = username;
        return this;
    }

    @Generated
    public StandaloneConnectorProperties setPassword(String password) {
        this.password = password;
        return this;
    }

    @Generated
    public StandaloneConnectorProperties setToken(String token) {
        this.token = token;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StandaloneConnectorProperties)) {
            return false;
        }
        StandaloneConnectorProperties other = (StandaloneConnectorProperties)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$ccUrl = this.getCcUrl();
        String other$ccUrl = other.getCcUrl();
        if (this$ccUrl == null ? other$ccUrl != null : !this$ccUrl.equals(other$ccUrl)) {
            return false;
        }
        String this$baseUrl = this.getBaseUrl();
        String other$baseUrl = other.getBaseUrl();
        if (this$baseUrl == null ? other$baseUrl != null : !this$baseUrl.equals(other$baseUrl)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        return !(this$token == null ? other$token != null : !this$token.equals(other$token));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StandaloneConnectorProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $ccUrl = this.getCcUrl();
        result = result * 59 + ($ccUrl == null ? 43 : $ccUrl.hashCode());
        String $baseUrl = this.getBaseUrl();
        result = result * 59 + ($baseUrl == null ? 43 : $baseUrl.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "StandaloneConnectorProperties(ccUrl=" + this.getCcUrl() + ", baseUrl=" + this.getBaseUrl() + ", name=" + this.getName() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", token=" + this.getToken() + ")";
    }
}

